﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessAHOBPR.Extensions;
using VeteransAffairs.Registries.BusinessAHOBPR.PaymentService;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis
{
    public class RegistrantHistoryToDeploymentMapper
    {
        public List<ServiceSpecificOccupation> SetDeploymentOccupations(RegistrantHistory history, DateRange deploymentDateRange)
        {
            if (history == null) throw new ArgumentNullException(nameof(history));

            var mappedDeploymentOccupations = new List<ServiceSpecificOccupation>();
            //Occupations are organized by DateTime, so we're creating DateRanges out of those dates to be able to compare apples to apples
            //A Registrant may have the same occupation over multiple deployments.
            foreach (var range in history.OccupationDateTimesByDateRange.Keys)
            {
                //Console.WriteLine($"checking OccupationByDateRange. Start {range.Start.ToShortDateString()} - End {range.End.ToShortDateString()}");
                // Console.WriteLine($"Deployment Range: { deploymentDateRange.Start.ToShortDateString()} to { deploymentDateRange.End.ToShortDateString()}.");
                if (deploymentDateRange.HasOverlap(range))
                {
                    var key = history.OccupationDateTimesByDateRange[range];
                    // Console.WriteLine($" Deployment Start: {deploymentDateRange.Start.ToShortDateString()} - {deploymentDateRange.End.ToShortDateString()} OVERLAPS Occupation Start {range.Start.ToShortDateString()} - {range.End.ToShortDateString()}.  Count: {history.OccupationsByDateTime[key].Count}");
                    mappedDeploymentOccupations.AddRange(history.OccupationsByDateTime[key]);
                }
            }
            return mappedDeploymentOccupations;
        }
        public PayGradeHistoryData GetPayGradeHistoryForDateRange(RegistrantHistory history, DateRange deploymentsByDateRange)
        {
            PayGradeHistoryData data = null;
            foreach (var range in history.PaymentDateTimesByDateRange.Keys)
            {
                Trace.WriteLine($"Paydata range: {range.Start} -> {range.End}");
                if (deploymentsByDateRange.HasOverlap(range))
                {
                    Trace.WriteLine("Overlap");
                    var key = history.PaymentDateTimesByDateRange[range];
                    if (data == null)
                    {
                        Trace.WriteLine($"Setting Rank history for daterange -> {deploymentsByDateRange.Start} -> {deploymentsByDateRange.End} to {history.PaymentDataByDateTime[key].serviceRankNameTxt}");
                        data = history.PaymentDataByDateTime[key];
                    }
                    else
                    {
                        //Replace if newer
                        Trace.WriteLine($"Replace if newer:  was {data.payGradeDate} NOW {history.PaymentDataByDateTime[key]}");
                        if ((history.PaymentDataByDateTime[key].payGradeDate > data.payGradeDate)) { data = history.PaymentDataByDateTime[key]; }
                    }
                }
            }
            return data;
        }
        //public string GetPayGrade(RegistrantHistory history, DateRange deploymentsByDateRange)
        //{
        //    var rank = string.Empty;
        //    foreach (var range in history.PaymentDateTimesByDateRange.Keys)
        //    {
        //        if (deploymentsByDateRange.HasOverlap(range))
        //        {
        //            var key = history.PaymentDateTimesByDateRange[range];
        //            rank = history.PaymentDataByDateTime[key].p
        //        }
        //    }
        //    return rank;
        //}
    }
}
